# 画面設計書 2-Static Classes Demo

## 概要

本ドキュメントは、VBCorLibプロジェクトのサンプルアプリケーション「Static Classes Demo」の画面設計書です。

### 本画面の処理概要

Static Classes DemoはVBCorLibライブラリが提供する静的クラス群（Path、Environment、MathExt、TimeZone）の機能をデモンストレーションする画面です。フォーム読み込み時に各静的クラスのメソッドを実行し、結果を画面上のテキストボックスに表示します。

**業務上の目的・背景**：VBCorLibは.NET Frameworkの機能をVB6/VBAに移植したライブラリです。本画面は、開発者がライブラリの静的クラス機能を理解し、使用方法を学習するためのデモンストレーション目的で作成されています。Path操作、環境変数取得、数学関数、タイムゾーン情報取得など、頻繁に使用される機能の実例を提供します。

**画面へのアクセス方法**：Examples/Misc/StaticClasses/StaticClasses.vbpプロジェクトを開き、F5キーで実行することでこの画面が表示されます。

**主要な操作・処理内容**：
1. Path静的クラスのデモ - ファイルパスの分解・変換（GetFullPath、GetFileName、GetDirectoryName等）
2. Environment静的クラスのデモ - システム環境情報取得（UserName、MachineName、OSVersion等）
3. MathExt（CorMath）のデモ - 数学関数（PI、度/ラジアン変換、DivRem、Ceiling、Floor）
4. TimeZone静的クラスのデモ - タイムゾーン情報取得（夏時間判定、標準名、オフセット等）

**画面遷移**：本画面は独立したデモアプリケーションであり、他の画面への遷移はありません。

**権限による表示制御**：本画面は開発者向けデモツールであり、特別な権限制御は実装されていません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 39 | Path | 主機能 | パス操作機能のデモ（GetFullPath、GetFileName、GetDirectoryName、GetPathRoot、GetExtension、ChangeExtension） |
| 8 | Environment | 主機能 | 環境情報取得のデモ（UserName、MachineName、WorkingSet、ExpandEnvironmentVariables、GetLogicalDrives、OSVersion） |
| 2 | CorString | 補助機能 | 文字列フォーマット処理（数値フォーマット、環境変数展開結果の表示） |
| 14 | CorMath | 主機能 | 数学関数のデモ（PI、CDeg、CRad、DivRem、Ceiling、Floor） |
| 5 | TimeZone | 主機能 | タイムゾーン情報のデモ（CurrentTimeZone、IsDayLightSavingTime、DayLightName、StandardName、GetDayLightChanges） |

## 画面種別

デモンストレーション / 情報表示

## URL/ルーティング

VB6デスクトップアプリケーションのため、URLルーティングは存在しません。フォームファイル: `Examples/Misc/StaticClasses/Form1.frm`

## 入出力項目

本画面は読み取り専用の情報表示画面です。入力項目はありません。

| 項目名 | 項目種別 | 説明 |
|--------|----------|------|
| 全テキストボックス | 出力 | Locked=Trueで読み取り専用 |

## 表示項目

### Path フレーム

| 項目名 | コントロール | データ型 | 説明 |
|--------|-------------|----------|------|
| txtFullPath | TextBox | String | ファイルのフルパス |
| txtFileName | TextBox | String | ファイル名（拡張子含む） |
| txtDirectory | TextBox | String | ディレクトリ部分 |
| txtRootDirectory | TextBox | String | ルートディレクトリ |
| txtFileNameNoExt | TextBox | String | ファイル名（拡張子なし） |
| txtExtension | TextBox | String | 拡張子 |
| txtChangeExtension | TextBox | String | 拡張子変更後のパス |

### Environment フレーム

| 項目名 | コントロール | データ型 | 説明 |
|--------|-------------|----------|------|
| txtUserName | TextBox | String | ログインユーザー名 |
| txtComputerName | TextBox | String | コンピュータ名 |
| txtMemoryUsage | TextBox | String | メモリ使用量（NTのみ） |
| txtExpandVariable | TextBox | String | 環境変数展開結果 |
| txtLogicalDrives | TextBox | String | 論理ドライブ一覧 |
| txtOperatingSystem | TextBox | String | OS情報 |

### MathExt フレーム

| 項目名 | コントロール | データ型 | 説明 |
|--------|-------------|----------|------|
| txtPI | TextBox | String | 円周率 |
| txtRadToDeg | TextBox | String | ラジアンから度への変換例 |
| txtDegToRad | TextBox | String | 度からラジアンへの変換例 |
| txtDivRem | TextBox | String | 除算と剰余の同時計算結果 |
| txtCeilings | TextBox | String | 切り上げ計算例 |
| txtFloors | TextBox | String | 切り捨て計算例 |

### TimeZone フレーム

| 項目名 | コントロール | データ型 | 説明 |
|--------|-------------|----------|------|
| txtIsDayLightSavings | TextBox | String | 夏時間適用中かどうか |
| txtDayLightName | TextBox | String | 夏時間名 |
| txtStandardName | TextBox | String | 標準時間名 |
| txtTimeZoneOffset | TextBox | String | タイムゾーンオフセット |
| txtDayLightStart | TextBox | String | 夏時間開始日時 |
| txtDayLightEnd | TextBox | String | 夏時間終了日時 |

## イベント仕様

### 1-Form_Load

フォーム読み込み時に全ての静的クラスデモを実行します。

**処理内容**:
1. DemonstratePath - Path静的クラスのデモ実行
2. DemonstrateEnvironment - Environment静的クラスのデモ実行
3. DemonstrateMathExt - 数学関数のデモ実行
4. DemonstrateTimeZone - TimeZone静的クラスのデモ実行

## データベース更新仕様

本画面はデータベースを使用しません。

## メッセージ仕様

本画面にメッセージ表示機能はありません。情報は直接テキストボックスに表示されます。

## 例外処理

| 例外種別 | 対処方法 |
|---------|---------|
| 環境依存エラー | Memory Usage（WorkingSet）はNT系のみで動作 |
| タイムゾーン情報取得エラー | タイムゾーンがサポートされない環境では空欄表示 |

## 備考

- BorderStyle = Fixed Single（サイズ変更不可）
- MaxButton = False, MinButton = False（最大化・最小化ボタン無効）
- 全テキストボックスはLocked = True（読み取り専用）
- CorString.Formatを使用した数値フォーマット例を含む

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面では特定のデータ構造は使用せず、VBCorLibの静的メソッド呼び出し結果を直接表示します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Form1.frm | `Examples/Misc/StaticClasses/Form1.frm` | フォームデザイナ部分（行1-461）でUI構成を理解 |

**読解のコツ**: VB6のフォームファイルはテキスト形式で、Begin VB.Frame〜End で各グループが定義されています。

#### Step 2: エントリーポイントを理解する

フォーム読み込み時の処理がエントリーポイントです。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Form1.frm | `Examples/Misc/StaticClasses/Form1.frm` | 行516-521 Form_Load |

**主要処理フロー**:
1. **行517**: DemonstratePath - パス操作デモ
2. **行518**: DemonstrateEnvironment - 環境情報デモ
3. **行519**: DemonstrateMathExt - 数学関数デモ
4. **行520**: DemonstrateTimeZone - タイムゾーンデモ

#### Step 3: 各デモメソッドを理解する

各静的クラスのデモメソッドを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Form1.frm | `Examples/Misc/StaticClasses/Form1.frm` | 行469-480 DemonstratePath - Path.GetFullPath等の使用例 |
| 3-2 | Form1.frm | `Examples/Misc/StaticClasses/Form1.frm` | 行482-489 DemonstrateEnvironment - Environment.UserName等の使用例 |
| 3-3 | Form1.frm | `Examples/Misc/StaticClasses/Form1.frm` | 行491-503 DemonstrateMathExt - PI、Ceiling、Floor等の使用例 |
| 3-4 | Form1.frm | `Examples/Misc/StaticClasses/Form1.frm` | 行505-514 DemonstrateTimeZone - TimeZone.CurrentTimeZone等の使用例 |

**主要処理フロー（DemonstratePath）**:
- **行470-471**: ファイル名から GetFullPath でフルパス取得
- **行473-479**: GetFileName、GetDirectoryName、GetPathRoot等でパス分解

**主要処理フロー（DemonstrateEnvironment）**:
- **行483**: Environment.UserName でユーザー名取得
- **行485**: CorString.Format で数値フォーマット
- **行486**: ExpandEnvironmentVariables で環境変数展開
- **行487**: CorString.Join でドライブ一覧結合

**主要処理フロー（DemonstrateMathExt）**:
- **行492**: PI定数の表示
- **行493-494**: CDeg、CRad で角度変換
- **行496-499**: DivRem で除算と剰余を同時取得
- **行501-502**: Ceiling、Floor で切り上げ・切り捨て

**主要処理フロー（DemonstrateTimeZone）**:
- **行506-507**: TimeZone.CurrentTimeZone.IsDayLightSavingTime
- **行508-512**: 夏時間名、標準名、オフセット、開始終了日時取得

### プログラム呼び出し階層図

```
Form_Load
    │
    ├─ DemonstratePath
    │      ├─ Path.GetFullPath
    │      ├─ Path.GetFileName
    │      ├─ Path.GetDirectoryName
    │      ├─ Path.GetPathRoot
    │      ├─ Path.GetFileNameWithoutExtension
    │      ├─ Path.GetExtension
    │      └─ Path.ChangeExtension
    │
    ├─ DemonstrateEnvironment
    │      ├─ Environment.UserName
    │      ├─ Environment.MachineName
    │      ├─ Environment.WorkingSet
    │      ├─ CorString.Format
    │      ├─ Environment.ExpandEnvironmentVariables
    │      ├─ Environment.GetLogicalDrives
    │      ├─ CorString.Join
    │      └─ Environment.OSVersion.ToString
    │
    ├─ DemonstrateMathExt
    │      ├─ PI
    │      ├─ CDeg
    │      ├─ CRad
    │      ├─ DivRem
    │      ├─ Ceiling
    │      ├─ Floor
    │      └─ CorString.Format
    │
    └─ DemonstrateTimeZone
           ├─ TimeZone.CurrentTimeZone
           ├─ .IsDayLightSavingTime
           ├─ .DayLightName
           ├─ .StandardName
           └─ .GetDayLightChanges
```

### データフロー図

```
[入力]               [処理]                    [出力]

"FileName.txt" ───▶ Path.GetFullPath ────────▶ txtFullPath
                          │
                          ▼
                    Path.GetFileName ────────▶ txtFileName
                          │
                          ▼
               Path.GetDirectoryName ────────▶ txtDirectory

システム情報 ─────▶ Environment.* ───────────▶ txtUserName等

現在時刻 ─────────▶ TimeZone.CurrentTimeZone ▶ txtIsDayLightSavings等
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Form1.frm | `Examples/Misc/StaticClasses/Form1.frm` | ソース | メインフォーム |
| StaticClasses.vbp | `Examples/Misc/StaticClasses/StaticClasses.vbp` | プロジェクト | プロジェクト定義 |
| VBCorLib.dll | 外部 | DLL | VBCorLibライブラリ本体 |
